﻿/*
Version: 1.0, requires Writemonkey 2.5.0.8 or higher

Release date: August 25th 2013

Author: Josip

Description: 
Show borderless window with rounded corners.

Installation:
Unzip the "Rounded monkey" directory into the plugins directory.

Deployment:
This plugin is initialized at startup. CTRL + click the right side of the wm window to toggle border visibility. Set radius and opacity in the js file.
*/

/////////////////////////
var radius = 8;
var opacity = 1; // use 1 for opaque, .50 for 50% transparency ...
/////////////////////////


var mouseOffset;

// store old default region
var r = monkey.form.Region;

setBorder (); // Set border at start


monkey.form.add_ClientSizeChanged(function(object, eventargs) {
	setBorder (); // Set border on resize
});



function setBorder () {
	if (monkey.form.WindowState != System.Windows.Forms.FormWindowState.Maximized && monkey.form.FormBorderStyle == System.Windows.Forms.FormBorderStyle.None) {
		var rect = new System.Drawing.Rectangle(-1, -1, monkey.form.Width, monkey.form.Height);
		monkey.form.Region = new System.Drawing.Region(createRoundedRectanglePath(rect, radius));
		monkey.form.Opacity = opacity;
	}
	else {
		monkey.form.Region = r;
		monkey.form.Opacity = monkey.settings["_opacity"];
		monkey.form.Invalidate();
	}
}


function createRoundedRectanglePath(rect, cornerRadius) {
	var roundedRect = new System.Drawing.Drawing2D.GraphicsPath();
	roundedRect.AddArc(rect.X, rect.Y, cornerRadius * 2, cornerRadius * 2, 180, 90);
	roundedRect.AddLine(rect.X + cornerRadius, rect.Y, rect.Right - cornerRadius * 2, rect.Y);
	roundedRect.AddArc(rect.X + rect.Width - cornerRadius * 2, rect.Y, cornerRadius * 2, cornerRadius * 2, 270, 90);
	roundedRect.AddLine(rect.Right, rect.Y + cornerRadius * 2, rect.Right, rect.Y + rect.Height - cornerRadius * 2);

	roundedRect.AddArc(rect.X + rect.Width - cornerRadius * 2, rect.Y + rect.Height - cornerRadius * 2, cornerRadius * 2, cornerRadius * 2, 0, 90);

	roundedRect.AddLine(rect.Right - cornerRadius * 2, rect.Bottom, rect.X + cornerRadius * 2, rect.Bottom);
	roundedRect.AddArc(rect.X, rect.Bottom - cornerRadius * 2, cornerRadius * 2, cornerRadius * 2, 90, 90);
	roundedRect.AddLine(rect.X, rect.Bottom - cornerRadius * 2, rect.X, rect.Y + cornerRadius * 2);
	roundedRect.CloseFigure();
	return roundedRect;
}




/// END ///